/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.remsrv;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.remsrv.RemoteServiceData;
import java.util.Map;

public class RemoteServiceManager {
    private static final String TRACE_MASKT = "XRSFRSMT";
    private static final String TRACE_MASKF = "XRSFRSMF";
    private static final String TRACE_MASKD = "XRSFRSMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RSF-RmSrvMgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.p.remsrv.RemoteServiceData";
    private static RemoteServiceManager remoteSrvMgr = null;
    private Object dataLock = new Object();

    private RemoteServiceManager() {
        Trace.trace(TRACE_MASKT, "<> RemoteServiceManager()");
    }

    public static synchronized RemoteServiceManager getRemoteServiceManager() {
        Trace.trace(TRACE_MASKT, "-> getRemoteServiceManager()");
        if (remoteSrvMgr == null) {
            remoteSrvMgr = new RemoteServiceManager();
        }
        Trace.trace(TRACE_MASKT, "<- getRemoteServiceManager()");
        return remoteSrvMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteServiceData getRemoteServiceData() {
        Trace.trace(TRACE_MASKT, "-> getRemoteServiceData()");
        RemoteServiceData remoteSrvData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    remoteSrvData = (RemoteServiceData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 1138, pe).log();
                    remoteSrvData = new RemoteServiceData();
                }
            } else {
                remoteSrvData = new RemoteServiceData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getRemoteServiceData()");
        return remoteSrvData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteServiceData(RemoteServiceData data) {
        Trace.trace(TRACE_MASKT, "-> setRemoteServiceData()");
        Trace.trace(TRACE_MASKF, data.toString());
        Object object = this.dataLock;
        synchronized (object) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
            }
            catch (PersistenceException pe) {
                new FrameworkLog(classLogInfo, 1138, pe).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- setRemoteServiceData()");
    }

    public boolean isRemoteServiceEnabled(String type, String model, String serial) {
        Trace.trace(TRACE_MASKT, "-> isRemoteServiceEanbled(" + type + "," + model + "," + serial + ")");
        boolean isEnabled = true;
        RemoteServiceData remoteSrvData = this.getRemoteServiceData();
        Map enablement = remoteSrvData.getEnablement();
        String key = type + "-" + model + "/" + serial;
        if (enablement.containsKey(key)) {
            isEnabled = (Boolean)enablement.get(key);
        }
        Trace.trace(TRACE_MASKT, "<- isRemoteServiceEanbled() " + isEnabled);
        return isEnabled;
    }
}

